# 🚀 INSTALAÇÃO RÁPIDA - EXPRESSO TV

## ⚡ INÍCIO RÁPIDO (5 minutos)

### Opção 1: Android Studio (Recomendado para Desenvolvedores)

```bash
1. Extraia o arquivo expresso-tv-app.zip
2. Abra o Android Studio
3. File → Open → Selecione a pasta 'expresso-tv-app'
4. Aguarde o Gradle Sync (pode levar 2-3 minutos)
5. Conecte um celular Android ou inicie um emulador
6. Clique no botão verde "Run" ▶️
```

**Pronto! O app será instalado e aberto automaticamente.**

### Opção 2: Compilar APK

Se você quer apenas o arquivo APK para instalar:

```bash
1. Abra o projeto no Android Studio (passos acima)
2. Build → Build Bundle(s) / APK(s) → Build APK(s)
3. Aguarde a compilação
4. O APK estará em: app/build/outputs/apk/debug/app-debug.apk
5. Transfira o APK para seu celular
6. Instale normalmente
```

### Opção 3: Linha de Comando

Para usuários avançados:

```bash
cd expresso-tv-app
./gradlew assembleDebug
```

O APK será gerado em `app/build/outputs/apk/debug/`

## 📋 PRÉ-REQUISITOS

### Para Compilar:
- ✅ Android Studio Arctic Fox ou superior
- ✅ JDK 11 ou superior
- ✅ SDK Android (API 24+)

### Para Usar o App:
- ✅ Android 7.0 (Nougat) ou superior
- ✅ WhatsApp instalado
- ✅ ~15 MB de espaço livre

## 🎯 PRIMEIRA VEZ NO ANDROID STUDIO?

### 1. Instale o Android Studio
- Baixe em: https://developer.android.com/studio
- Execute o instalador
- Siga o assistente de configuração

### 2. Configure o SDK
- O Android Studio configurará automaticamente
- Aguarde o download dos componentes

### 3. Conecte seu Celular (Modo Debug)

**No celular:**
1. Vá em **Configurações**
2. Sobre o telefone
3. Toque **7 vezes** em "Número da versão"
4. Volte e entre em **Opções do desenvolvedor**
5. Ative **"Depuração USB"**
6. Conecte o cabo USB no computador
7. Autorize o computador no celular

**No Android Studio:**
- Seu celular aparecerá no topo
- Clique em Run

### 4. Ou Use um Emulador

Se não tem celular Android:
1. No Android Studio: Tools → Device Manager
2. Clique em "Create Virtual Device"
3. Escolha um modelo (ex: Pixel 5)
4. Selecione uma versão do Android (API 30+)
5. Clique em "Finish"
6. Inicie o emulador

## 🔧 SOLUÇÃO DE PROBLEMAS

### "Gradle Sync Failed"
```bash
Solução:
- File → Invalidate Caches / Restart
- Build → Clean Project
- Build → Rebuild Project
```

### "SDK Not Found"
```bash
Solução:
- File → Project Structure
- SDK Location → Selecione o caminho do SDK
- Apply
```

### "Build Failed"
```bash
Solução:
1. Verifique sua conexão com internet
2. Tools → SDK Manager → SDK Tools
3. Instale "Google Repository" e "Android Support Repository"
4. Rebuild
```

### Emulador Não Inicia
```bash
Solução:
- Tools → AVD Manager
- Delete o dispositivo virtual
- Crie um novo
- Certifique-se de ter 8GB+ de RAM disponível
```

## 📱 TESTANDO O APP

### Ao Abrir pela Primeira Vez:
1. ✅ Você verá uma tela vazia com "Nenhum cliente cadastrado"
2. ✅ Botão + (flutuante) no canto inferior direito
3. ✅ Barra superior com "Expresso TV"

### Teste Rápido:
1. Toque no botão **+**
2. Preencha:
   - Nome: "Teste Cliente"
   - Telefone: "11999887766"
   - Plano: "Premium"
   - Valor: "99.90"
   - Selecione uma data futura
3. Toque em "Salvar Cliente"
4. ✅ Cliente aparecerá na lista principal

### Teste WhatsApp:
1. Abra o cliente criado
2. Toque em "Enviar Mensagem WhatsApp"
3. ✅ WhatsApp abrirá com mensagem pronta

## 🎓 ESTRUTURA DO PROJETO

```
expresso-tv-app/
│
├── AndroidManifest.xml          # Configurações do app
├── build.gradle                 # Dependências
│
├── src/main/java/com/expressotv/manager/
│   ├── data/                    # Camada de dados
│   │   ├── Client.kt
│   │   ├── ClientDao.kt
│   │   ├── ClientDatabase.kt
│   │   └── ClientRepository.kt
│   │
│   ├── viewmodel/               # Lógica de negócio
│   │   └── ClientViewModel.kt
│   │
│   ├── adapter/                 # Adapter da lista
│   │   └── ClientAdapter.kt
│   │
│   ├── utils/                   # Utilitários
│   │   ├── WhatsAppHelper.kt
│   │   └── NotificationHelper.kt
│   │
│   ├── databinding/             # ViewBinding
│   │   └── (4 arquivos)
│   │
│   ├── MainActivity.kt          # Tela principal
│   ├── AddClientActivity.kt     # Adicionar cliente
│   └── ClientDetailsActivity.kt # Detalhes
│
├── src/main/res/
│   ├── layout/                  # Layouts XML
│   ├── values/                  # Cores, strings, temas
│   ├── menu/                    # Menus
│   └── drawable/                # Imagens e shapes
│
├── README.md                    # Documentação técnica
├── MANUAL_USUARIO.md           # Manual do usuário
├── RESUMO_FUNCIONALIDADES.md   # Resumo completo
└── INSTALACAO_RAPIDA.md        # Este arquivo
```

## 📚 PRÓXIMOS PASSOS

Após instalar com sucesso:

1. 📖 Leia o **MANUAL_USUARIO.md** para aprender a usar
2. 🎨 Leia o **RESUMO_FUNCIONALIDADES.md** para ver todas as features
3. 💻 Leia o **README.md** para detalhes técnicos
4. 🚀 Comece a cadastrar seus clientes!

## 💡 DICAS

### Desenvolvimento:
- ✅ Use o **Logcat** para ver logs em tempo real
- ✅ Use o **Layout Inspector** para debug de UI
- ✅ Ative **Instant Run** para builds mais rápidos

### Personalização:
- 🎨 Altere cores em: `res/values/colors.xml`
- 📝 Altere textos em: `res/values/strings.xml`
- 💬 Altere mensagens WhatsApp em: `WhatsAppHelper.kt`

### Performance:
- ⚡ O app usa Room Database (rápido e eficiente)
- ⚡ LiveData atualiza UI automaticamente
- ⚡ Coroutines para operações assíncronas

## 🆘 PRECISA DE AJUDA?

### Recursos Úteis:
- 📘 [Documentação Android](https://developer.android.com/docs)
- 📘 [Kotlin Documentation](https://kotlinlang.org/docs/)
- 📘 [Room Database Guide](https://developer.android.com/training/data-storage/room)
- 📘 [Material Design](https://material.io/design)

### Erros Comuns:

**"Cannot resolve symbol R"**
- Build → Clean Project → Rebuild

**"App keeps crashing"**
- Verifique o Logcat para erro específico
- Verifique permissões no AndroidManifest.xml

**"WhatsApp não abre"**
- Verifique se WhatsApp está instalado
- Teste com número de telefone válido

## ✅ CHECKLIST DE INSTALAÇÃO

- [ ] Android Studio instalado
- [ ] SDK Android configurado
- [ ] Projeto extraído e aberto
- [ ] Gradle Sync completado
- [ ] Celular conectado ou emulador iniciado
- [ ] App compilado com sucesso
- [ ] App instalado e abrindo
- [ ] Teste de cadastro funcionando
- [ ] Integração WhatsApp testada

## 🎉 SUCESSO!

Se você chegou até aqui e tudo funcionou:

**PARABÉNS! 🎊**

Você agora tem um aplicativo profissional de gerenciamento de clientes funcionando!

---

**Tempo médio de instalação**: 5-10 minutos  
**Dificuldade**: ⭐⭐ (Fácil)  
**Suporte**: Documentação completa incluída

**Desenvolvido para facilitar sua gestão de clientes! 📺✨**
