# Expresso TV - Manual de Instalação e Uso

## 🎯 Guia Rápido de Instalação

### Opção 1: Abrir no Android Studio (Recomendado)

1. **Baixe e extraia** a pasta do projeto
2. **Abra o Android Studio**
3. Clique em **File → Open**
4. Navegue até a pasta `expresso-tv-app` e selecione
5. Aguarde o **Gradle sync** completar
6. Conecte seu celular Android ou inicie um **emulador**
7. Clique no botão **Run** (▶️) verde

### Opção 2: Compilar via Linha de Comando

```bash
cd expresso-tv-app
./gradlew assembleDebug
```

O APK será gerado em: `app/build/outputs/apk/debug/app-debug.apk`

## 📱 Requisitos do Sistema

- **Android**: 7.0 (Nougat) ou superior
- **Espaço**: ~15 MB
- **WhatsApp**: Necessário para envio de mensagens
- **Internet**: Para integração WhatsApp

## 🎬 Primeiros Passos

### 1. Primeiro Acesso
Ao abrir o app pela primeira vez, você verá:
- Tela vazia com mensagem "Nenhum cliente cadastrado"
- Botão **+** (FAB) no canto inferior direito

### 2. Cadastrar Primeiro Cliente

**Passo a passo:**
1. Toque no botão **+**
2. Preencha os campos:
   - **Nome**: Ex: "João Silva"
   - **Telefone**: Ex: "11999887766" (apenas números)
   - **Tipo de Plano**: Escolha entre Básico, Padrão, Premium, VIP
   - **Valor Mensal**: Ex: "99.90"
   - **Data de Vencimento**: Toque em "Selecionar Data"
   - **Observações**: Campo opcional
3. Toque em **"Salvar Cliente"**

### 3. Visualizar Dashboard

Após adicionar clientes, você verá:
- **Estatísticas** no topo:
  - Total de clientes
  - Clientes vencendo (próximos 7 dias)
  - Clientes vencidos
- **Lista de clientes** com cards coloridos:
  - 🟢 Verde: Mais de 7 dias
  - 🟠 Laranja: Vence em 7 dias ou menos
  - 🔴 Vermelho: Vencido

## 💬 Usando a Integração WhatsApp

### Enviar Mensagem de Cobrança

1. Toque em um **cliente** na lista
2. Toque em **"💬 Enviar Mensagem WhatsApp"**
3. O WhatsApp abrirá automaticamente com uma mensagem personalizada:
   - Status do vencimento
   - Data de vencimento
   - Valor do plano
4. **Revise a mensagem** e envie

### Formato do Número

⚠️ **Importante**: Cadastre o telefone apenas com números:
- ✅ Correto: `11999887766`
- ❌ Errado: `(11) 99988-7766`

O app adiciona automaticamente o código do Brasil (+55).

## 🔄 Renovar Plano de Cliente

### Método Rápido

1. Abra os **detalhes do cliente**
2. Toque em **"🔄 Renovar Plano"**
3. Selecione a **nova data de vencimento**
4. Confirme

O status do cliente será atualizado automaticamente!

## 🔍 Buscar Clientes

1. Toque no ícone de **busca** 🔍 (canto superior direito)
2. Digite:
   - Nome do cliente, ou
   - Parte do telefone
3. Os resultados aparecem em tempo real

## 🔔 Notificações

### Configurar Notificações

O app envia notificações automáticas para:
- Clientes vencendo nos próximos 7 dias
- Clientes com planos vencidos

**Verificação**: Diária, às 9h da manhã

### Permitir Notificações

1. Quando solicitado, toque em **"Permitir"**
2. Ou vá em: Configurações → Apps → Expresso TV → Notificações

## 📊 Gerenciamento de Clientes

### Editar Cliente
1. Abra os detalhes do cliente
2. Toque em **"✏️ Editar Dados"**
3. Modifique os campos necessários
4. Salve

### Excluir Cliente
1. Abra os detalhes do cliente
2. Role até o final
3. Toque em **"🗑️ Excluir Cliente"** (botão vermelho)
4. Confirme a exclusão

⚠️ **Atenção**: Esta ação é irreversível!

### Ligar para Cliente
1. Abra os detalhes do cliente
2. Toque em **"📞 Ligar para Cliente"**
3. Confirme a ligação no discador

## 📈 Interpretando o Dashboard

### Card de Estatísticas

```
┌─────────────────────────────────┐
│  Total: 50  │  Vencendo: 8  │  Vencidos: 3  │
└─────────────────────────────────┘
```

- **Total**: Clientes ativos no sistema
- **Vencendo**: Vencem nos próximos 7 dias
- **Vencidos**: Já passaram da data de vencimento

### Cards de Clientes

Cada card mostra:
- Nome do cliente
- Telefone
- Tipo de plano (badge colorido)
- Data de vencimento
- Dias restantes (grande, no lado direito)
- Valor mensal

## 🎨 Entendendo as Cores

| Cor | Status | Descrição |
|-----|--------|-----------|
| 🟢 Verde | Ativo | Mais de 7 dias até vencer |
| 🟠 Laranja | Atenção | Vence em 7 dias ou menos |
| 🔴 Vermelho | Vencido | Data de vencimento passou |

## 🛠️ Solução de Problemas

### WhatsApp não abre
**Problema**: Ao tentar enviar mensagem, nada acontece  
**Solução**: 
- Verifique se o WhatsApp está instalado
- Atualize o WhatsApp para a última versão
- Verifique se o número está correto (apenas dígitos)

### Notificações não aparecem
**Problema**: Não recebo lembretes de vencimento  
**Solução**:
- Vá em Configurações → Apps → Expresso TV
- Ative "Notificações"
- Ative "Exibir notificações"
- Desative "Otimização de bateria" para o app

### App não salva clientes
**Problema**: Cliente desaparece após adicionar  
**Solução**:
- Verifique se todos os campos obrigatórios estão preenchidos
- Reinicie o app
- Verifique o espaço de armazenamento do dispositivo

### Erro ao abrir o app
**Problema**: App fecha ao iniciar  
**Solução**:
- Limpe o cache: Configurações → Apps → Expresso TV → Limpar Cache
- Se persistir, desinstale e reinstale

## 💡 Dicas e Melhores Práticas

### Organização
- ✅ Cadastre clientes assim que fechar contrato
- ✅ Use observações para informações importantes
- ✅ Revise o dashboard diariamente
- ✅ Renove planos assim que receber pagamento

### WhatsApp
- ✅ Personalize as mensagens antes de enviar
- ✅ Seja cordial e profissional
- ✅ Envie lembretes 3 dias antes do vencimento
- ✅ Confirme pagamentos por mensagem

### Dados
- ✅ Faça backup regular dos dados
- ✅ Mantenha números atualizados
- ✅ Use nomes completos para fácil identificação

## 📞 Fluxo de Trabalho Recomendado

### Diariamente
1. Abra o app e verifique o dashboard
2. Confira clientes "Vencendo"
3. Envie mensagens via WhatsApp para lembretes
4. Atualize status de pagamentos recebidos

### Semanalmente
1. Revise clientes vencidos
2. Entre em contato com inadimplentes
3. Atualize observações necessárias

### Mensalmente
1. Analise total de clientes ativos
2. Calcule receita mensal
3. Identifique padrões de inadimplência

## 🎓 Recursos Adicionais

### Tipos de Plano Sugeridos

| Plano | Canais | Sugestão de Preço |
|-------|--------|-------------------|
| Básico | 50-100 | R$ 40-60 |
| Padrão | 100-200 | R$ 70-90 |
| Premium | 200-300 | R$ 100-130 |
| VIP | 300+ | R$ 150+ |

### Templates de Mensagem Personalizadas

Você pode editar os templates em:  
`WhatsAppHelper.kt` → função `generateExpirationMessage()`

## 🔐 Segurança e Privacidade

- ✅ Dados armazenados localmente no dispositivo
- ✅ Nenhuma informação enviada para servidores
- ✅ Banco de dados criptografado pelo Android
- ✅ Permissões mínimas necessárias

## 📱 Compatibilidade

### Testado em:
- ✅ Android 7.0 - 14.0
- ✅ Samsung, Xiaomi, Motorola, LG
- ✅ Telas de 4" a 7"

### Não compatível:
- ❌ Android 6.0 ou inferior
- ❌ Tablets (layout não otimizado)

---

**Dúvidas?** Consulte o arquivo `README.md` para informações técnicas detalhadas.

**Versão do Manual**: 1.0  
**Data**: Fevereiro 2026
