# 📺 Expresso TV - Gerenciador de Clientes

## Descrição
**Expresso TV** é um aplicativo Android completo para gerenciamento de clientes de serviços de TV por assinatura. O aplicativo permite organizar clientes, controlar datas de vencimento, enviar mensagens automatizadas via WhatsApp e receber notificações sobre vencimentos.

## 🚀 Funcionalidades

### ✅ Gerenciamento de Clientes
- ✏️ **Cadastrar clientes** com informações completas
- 📋 **Visualizar lista** de todos os clientes
- 🔍 **Buscar clientes** por nome ou telefone
- ✏️ **Editar** dados dos clientes
- 🗑️ **Excluir** clientes

### 📅 Controle de Vencimentos
- 📊 **Dashboard** com estatísticas (Total, Vencendo, Vencidos)
- 🔴 **Alertas visuais** por status:
  - Verde: Cliente ativo (mais de 7 dias)
  - Laranja: Vencimento próximo (até 7 dias)
  - Vermelho: Plano vencido
- 🔄 **Renovação rápida** de planos
- 📆 **Seletor de data** intuitivo

### 💬 Integração WhatsApp
- 📱 **Envio automático de mensagens** personalizadas
- 📝 **Templates de mensagens** para diferentes situações:
  - Aviso de vencimento próximo
  - Notificação de plano vencido
  - Confirmação de pagamento
  - Mensagem de boas-vindas
- 📞 **Ligação direta** para o cliente

### 🔔 Notificações Inteligentes
- ⏰ **Notificações automáticas** diárias
- 🎯 **Lembretes personalizados** por cliente
- 🔕 **Sistema de notificações** configurável

### 📊 Tipos de Plano
- Básico
- Padrão
- Premium
- VIP

## 🛠️ Tecnologias Utilizadas

### Linguagem
- **Kotlin** - Linguagem moderna para Android

### Arquitetura
- **MVVM** (Model-View-ViewModel)
- **LiveData** para observação de dados
- **Coroutines** para operações assíncronas

### Banco de Dados
- **Room Database** - Persistência local de dados
- **DAO** (Data Access Object)
- **Repository Pattern**

### UI/UX
- **Material Design 3**
- **ViewBinding** para acesso seguro às views
- **RecyclerView** com DiffUtil
- **CardView** para cards de clientes
- **CoordinatorLayout** para layouts responsivos

### Bibliotecas Principais
```gradle
// AndroidX Core
androidx.core:core-ktx:1.12.0
androidx.appcompat:appcompat:1.6.1
com.google.android.material:material:1.11.0

// Room Database
androidx.room:room-runtime:2.6.1
androidx.room:room-ktx:2.6.1

// Lifecycle & ViewModel
androidx.lifecycle:lifecycle-viewmodel-ktx:2.7.0
androidx.lifecycle:lifecycle-livedata-ktx:2.7.0

// Coroutines
kotlinx-coroutines-android:1.7.3

// WorkManager (Notificações)
androidx.work:work-runtime-ktx:2.9.0
```

## 📱 Estrutura do Projeto

```
com.expressotv.manager/
│
├── data/
│   ├── Client.kt              # Modelo de dados
│   ├── ClientDao.kt           # Interface de acesso aos dados
│   ├── ClientDatabase.kt      # Configuração do banco
│   └── ClientRepository.kt    # Camada de repositório
│
├── viewmodel/
│   └── ClientViewModel.kt     # ViewModel principal
│
├── adapter/
│   └── ClientAdapter.kt       # Adapter do RecyclerView
│
├── utils/
│   ├── WhatsAppHelper.kt      # Geração de mensagens
│   └── NotificationHelper.kt  # Sistema de notificações
│
├── MainActivity.kt            # Tela principal (lista)
├── AddClientActivity.kt       # Tela de adicionar cliente
├── ClientDetailsActivity.kt   # Tela de detalhes
└── NotificationReceiver.kt    # Receptor de notificações
```

## 🎨 Recursos Visuais

### Cores do Status
- 🟢 **Verde** (#E8F5E9): Cliente ativo
- 🟠 **Laranja** (#FFF3E0): Vencimento próximo
- 🔴 **Vermelho** (#FFEBEE): Plano vencido

### Tema
- **Primary Color**: #1976D2 (Azul)
- **Accent Color**: #00BCD4 (Ciano)

## 📋 Instalação

### Pré-requisitos
- Android Studio Arctic Fox ou superior
- JDK 11 ou superior
- SDK Android 24 (Android 7.0) ou superior
- Gradle 7.0+

### Passos de Instalação

1. **Clone ou baixe o projeto**
```bash
cd /caminho/do/projeto
```

2. **Abra no Android Studio**
   - File → Open
   - Selecione a pasta do projeto

3. **Sincronize o Gradle**
   - O Android Studio sincronizará automaticamente
   - Ou clique em "Sync Now"

4. **Execute o aplicativo**
   - Conecte um dispositivo Android ou inicie um emulador
   - Clique em "Run" (▶️)

## 🔧 Configuração

### Permissões Necessárias
O app solicita as seguintes permissões:

```xml
<uses-permission android:name="android.permission.INTERNET" />
<uses-permission android:name="android.permission.POST_NOTIFICATIONS" />
<uses-permission android:name="android.permission.SCHEDULE_EXACT_ALARM" />
```

### Integração WhatsApp

O app usa a **API do WhatsApp Web** para enviar mensagens:
```kotlin
val url = "https://api.whatsapp.com/send?phone=55${phone}&text=${message}"
```

**Importante**: 
- O número deve incluir o código do país (55 para Brasil)
- O WhatsApp deve estar instalado no dispositivo
- O formato do número: apenas dígitos (DDD + número)

## 📖 Como Usar

### 1. Adicionar Cliente
- Toque no botão **+** (FAB) na tela principal
- Preencha os dados:
  - Nome do cliente
  - Telefone (WhatsApp)
  - Tipo de plano
  - Valor mensal
  - Data de vencimento
  - Observações (opcional)
- Toque em **"Salvar Cliente"**

### 2. Visualizar Clientes
- A tela principal mostra todos os clientes ativos
- Cards com cores indicando o status
- Estatísticas no topo (Total, Vencendo, Vencidos)

### 3. Buscar Cliente
- Toque no ícone de busca 🔍 no menu
- Digite nome ou telefone

### 4. Enviar Mensagem WhatsApp
- Toque no cliente desejado
- Toque em **"💬 Enviar Mensagem WhatsApp"**
- O WhatsApp abrirá com mensagem pré-formatada
- Revise e envie

### 5. Renovar Plano
- Abra os detalhes do cliente
- Toque em **"🔄 Renovar Plano"**
- Selecione a nova data de vencimento
- Confirme

## 📨 Templates de Mensagens

### Vencimento Próximo (≤ 3 dias)
```
🟠 *Expresso TV - Aviso de Vencimento*

Olá, *[Nome]*!

Seu plano *[Tipo]* vence em *X dias*!

📅 Vencimento: DD/MM/AAAA
💰 Valor: R$ XX,XX

⏰ Renove agora para não perder o acesso!
```

### Plano Vencido
```
🔴 *Expresso TV - Aviso Importante*

Olá, *[Nome]*!

Seu plano está VENCIDO há X dias.

📅 Vencimento: DD/MM/AAAA
💰 Valor: R$ XX,XX

⚠️ Renove o quanto antes!
```

## 🔔 Sistema de Notificações

O app verifica **diariamente** os vencimentos e envia notificações:
- Clientes com vencimento em até 7 dias
- Clientes com planos vencidos

As notificações são gerenciadas pelo **WorkManager** para garantir execução mesmo com o app fechado.

## 🗄️ Banco de Dados

### Estrutura da Tabela `clients`

| Campo | Tipo | Descrição |
|-------|------|-----------|
| id | Int | Chave primária (auto-incremento) |
| name | String | Nome do cliente |
| phone | String | Telefone (WhatsApp) |
| planType | String | Tipo do plano |
| expirationDate | Long | Data de vencimento (timestamp) |
| monthlyPrice | Double | Valor mensal |
| isActive | Boolean | Status do cliente |
| notes | String | Observações |
| createdAt | Long | Data de criação |

## 🚀 Melhorias Futuras

- [ ] Backup e restauração de dados
- [ ] Exportação para Excel/CSV
- [ ] Gráficos de receita mensal
- [ ] Histórico de pagamentos
- [ ] Envio automático de mensagens
- [ ] Sincronização na nuvem
- [ ] Modo escuro
- [ ] Suporte a múltiplos usuários
- [ ] Relatórios mensais
- [ ] Integração com sistemas de pagamento

## 📄 Licença

Este projeto é de código aberto e pode ser usado livremente para fins educacionais e comerciais.

## 👨‍💻 Desenvolvedor

Aplicativo desenvolvido com ❤️ para facilitar o gerenciamento de clientes de TV por assinatura.

## 📞 Suporte

Para dúvidas ou sugestões sobre o código, consulte a documentação do Android ou comunidades de desenvolvimento Android.

---

**Versão**: 1.0  
**Última Atualização**: Fevereiro 2026  
**Compatibilidade**: Android 7.0 (API 24) ou superior
