package com.expressotv.manager.data

import androidx.room.Entity
import androidx.room.PrimaryKey
import java.text.SimpleDateFormat
import java.util.*

@Entity(tableName = "clients")
data class Client(
    @PrimaryKey(autoGenerate = true)
    val id: Int = 0,
    val name: String,
    val phone: String,
    val planType: String,
    val expirationDate: Long, // timestamp in milliseconds
    val monthlyPrice: Double,
    val isActive: Boolean = true,
    val notes: String = "",
    val createdAt: Long = System.currentTimeMillis()
) {
    fun getDaysUntilExpiration(): Int {
        val today = Calendar.getInstance().apply {
            set(Calendar.HOUR_OF_DAY, 0)
            set(Calendar.MINUTE, 0)
            set(Calendar.SECOND, 0)
            set(Calendar.MILLISECOND, 0)
        }.timeInMillis
        
        val expDate = Calendar.getInstance().apply {
            timeInMillis = expirationDate
            set(Calendar.HOUR_OF_DAY, 0)
            set(Calendar.MINUTE, 0)
            set(Calendar.SECOND, 0)
            set(Calendar.MILLISECOND, 0)
        }.timeInMillis
        
        val diffInMillis = expDate - today
        return (diffInMillis / (1000 * 60 * 60 * 24)).toInt()
    }
    
    fun getFormattedExpirationDate(): String {
        val sdf = SimpleDateFormat("dd/MM/yyyy", Locale.getDefault())
        return sdf.format(Date(expirationDate))
    }
    
    fun isExpired(): Boolean = getDaysUntilExpiration() < 0
    
    fun isExpiringSoon(): Boolean {
        val days = getDaysUntilExpiration()
        return days in 0..7
    }
}
