package com.expressotv.manager.data

import androidx.lifecycle.LiveData
import androidx.room.*

@Dao
interface ClientDao {
    
    @Query("SELECT * FROM clients ORDER BY expirationDate ASC")
    fun getAllClients(): LiveData<List<Client>>
    
    @Query("SELECT * FROM clients WHERE isActive = 1 ORDER BY expirationDate ASC")
    fun getActiveClients(): LiveData<List<Client>>
    
    @Query("SELECT * FROM clients WHERE id = :clientId")
    suspend fun getClientById(clientId: Int): Client?
    
    @Query("SELECT * FROM clients WHERE expirationDate BETWEEN :startDate AND :endDate")
    suspend fun getClientsExpiringBetween(startDate: Long, endDate: Long): List<Client>
    
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertClient(client: Client): Long
    
    @Update
    suspend fun updateClient(client: Client)
    
    @Delete
    suspend fun deleteClient(client: Client)
    
    @Query("SELECT COUNT(*) FROM clients WHERE isActive = 1")
    fun getActiveClientCount(): LiveData<Int>
    
    @Query("SELECT * FROM clients WHERE name LIKE '%' || :query || '%' OR phone LIKE '%' || :query || '%'")
    fun searchClients(query: String): LiveData<List<Client>>
}
