package com.expressotv.manager.data

import androidx.lifecycle.LiveData

class ClientRepository(private val clientDao: ClientDao) {
    
    val allClients: LiveData<List<Client>> = clientDao.getAllClients()
    val activeClients: LiveData<List<Client>> = clientDao.getActiveClients()
    val activeClientCount: LiveData<Int> = clientDao.getActiveClientCount()
    
    suspend fun insert(client: Client): Long {
        return clientDao.insertClient(client)
    }
    
    suspend fun update(client: Client) {
        clientDao.updateClient(client)
    }
    
    suspend fun delete(client: Client) {
        clientDao.deleteClient(client)
    }
    
    suspend fun getClientById(id: Int): Client? {
        return clientDao.getClientById(id)
    }
    
    suspend fun getClientsExpiringBetween(startDate: Long, endDate: Long): List<Client> {
        return clientDao.getClientsExpiringBetween(startDate, endDate)
    }
    
    fun searchClients(query: String): LiveData<List<Client>> {
        return clientDao.searchClients(query)
    }
}
