package com.expressotv.manager.utils

import android.app.NotificationChannel
import android.app.NotificationManager
import android.app.PendingIntent
import android.content.Context
import android.content.Intent
import android.os.Build
import androidx.core.app.NotificationCompat
import com.expressotv.manager.MainActivity
import com.expressotv.manager.R

object NotificationHelper {
    
    private const val CHANNEL_ID = "expresso_tv_notifications"
    private const val CHANNEL_NAME = "Lembretes de Vencimento"
    private const val CHANNEL_DESCRIPTION = "Notificações sobre vencimentos de clientes"
    
    fun createNotificationChannel(context: Context) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val importance = NotificationManager.IMPORTANCE_HIGH
            val channel = NotificationChannel(CHANNEL_ID, CHANNEL_NAME, importance).apply {
                description = CHANNEL_DESCRIPTION
            }
            
            val notificationManager = context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
            notificationManager.createNotificationChannel(channel)
        }
    }
    
    fun showExpirationNotification(context: Context, clientName: String, daysRemaining: Int) {
        val intent = Intent(context, MainActivity::class.java).apply {
            flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TASK
        }
        
        val pendingIntent = PendingIntent.getActivity(
            context,
            0,
            intent,
            PendingIntent.FLAG_IMMUTABLE
        )
        
        val title = when {
            daysRemaining < 0 -> "⚠️ Cliente com plano vencido!"
            daysRemaining <= 3 -> "🔔 Vencimento em $daysRemaining dias!"
            else -> "📅 Lembrete de vencimento"
        }
        
        val message = when {
            daysRemaining < 0 -> "$clientName está com o plano vencido há ${Math.abs(daysRemaining)} dias"
            else -> "O plano de $clientName vence em $daysRemaining dias"
        }
        
        val builder = NotificationCompat.Builder(context, CHANNEL_ID)
            .setSmallIcon(R.drawable.ic_notification)
            .setContentTitle(title)
            .setContentText(message)
            .setStyle(NotificationCompat.BigTextStyle().bigText(message))
            .setPriority(NotificationCompat.PRIORITY_HIGH)
            .setContentIntent(pendingIntent)
            .setAutoCancel(true)
        
        val notificationManager = context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
        notificationManager.notify(clientName.hashCode(), builder.build())
    }
}
