package com.expressotv.manager.utils

import com.expressotv.manager.data.Client
import java.text.SimpleDateFormat
import java.util.*

object WhatsAppHelper {
    
    fun generateExpirationMessage(client: Client): String {
        val daysUntil = client.getDaysUntilExpiration()
        
        return when {
            daysUntil < 0 -> {
                """
                🔴 *Expresso TV - Aviso Importante*
                
                Olá, *${client.name}*!
                
                Seu plano *${client.planType}* está VENCIDO há ${Math.abs(daysUntil)} dias.
                
                📅 Vencimento: ${client.getFormattedExpirationDate()}
                💰 Valor: R$ %.2f
                
                ⚠️ Para continuar aproveitando nossos serviços, por favor renove seu plano o quanto antes.
                
                Entre em contato para renovar! 📞
                """.trimIndent().format(client.monthlyPrice)
            }
            daysUntil <= 3 -> {
                """
                🟠 *Expresso TV - Aviso de Vencimento*
                
                Olá, *${client.name}*!
                
                Seu plano *${client.planType}* vence em *$daysUntil dias*!
                
                📅 Vencimento: ${client.getFormattedExpirationDate()}
                💰 Valor: R$ %.2f
                
                ⏰ Renove agora para não perder o acesso aos nossos canais!
                
                Qualquer dúvida, estamos à disposição! 😊
                """.trimIndent().format(client.monthlyPrice)
            }
            daysUntil <= 7 -> {
                """
                🟡 *Expresso TV - Lembrete de Vencimento*
                
                Olá, *${client.name}*!
                
                Seu plano *${client.planType}* vence em $daysUntil dias.
                
                📅 Vencimento: ${client.getFormattedExpirationDate()}
                💰 Valor: R$ %.2f
                
                Já pode ir providenciando a renovação para não ter interrupção no serviço! 📺
                
                Obrigado pela preferência! 🙏
                """.trimIndent().format(client.monthlyPrice)
            }
            else -> {
                """
                ✅ *Expresso TV*
                
                Olá, *${client.name}*!
                
                Seu plano *${client.planType}* está ativo e vence em $daysUntil dias.
                
                📅 Vencimento: ${client.getFormattedExpirationDate()}
                💰 Valor: R$ %.2f
                
                Aproveite nossos canais! 📺
                
                Qualquer dúvida, estamos à disposição! 😊
                """.trimIndent().format(client.monthlyPrice)
            }
        }
    }
    
    fun generatePaymentConfirmationMessage(client: Client): String {
        return """
            ✅ *Expresso TV - Pagamento Confirmado*
            
            Olá, *${client.name}*!
            
            Seu pagamento foi confirmado com sucesso! 🎉
            
            📅 Nova data de vencimento: ${client.getFormattedExpirationDate()}
            📦 Plano: ${client.planType}
            💰 Valor: R$ %.2f
            
            Obrigado pela confiança! Continue aproveitando nossos serviços! 📺
            
            Equipe Expresso TV
        """.trimIndent().format(client.monthlyPrice)
    }
    
    fun generateWelcomeMessage(client: Client): String {
        return """
            🎉 *Bem-vindo(a) à Expresso TV!*
            
            Olá, *${client.name}*!
            
            É um prazer ter você conosco! 🙌
            
            📦 Seu Plano: ${client.planType}
            📅 Vencimento: ${client.getFormattedExpirationDate()}
            💰 Valor mensal: R$ %.2f
            
            📺 Aproveite o melhor do entretenimento!
            
            Qualquer dúvida, estamos à disposição! 😊
            
            Equipe Expresso TV
        """.trimIndent().format(client.monthlyPrice)
    }
}
