package com.expressotv.manager.viewmodel

import android.app.Application
import androidx.lifecycle.AndroidViewModel
import androidx.lifecycle.LiveData
import androidx.lifecycle.viewModelScope
import com.expressotv.manager.data.Client
import com.expressotv.manager.data.ClientDatabase
import com.expressotv.manager.data.ClientRepository
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch

class ClientViewModel(application: Application) : AndroidViewModel(application) {
    
    private val repository: ClientRepository
    val allClients: LiveData<List<Client>>
    val activeClients: LiveData<List<Client>>
    val activeClientCount: LiveData<Int>
    
    init {
        val clientDao = ClientDatabase.getDatabase(application).clientDao()
        repository = ClientRepository(clientDao)
        allClients = repository.allClients
        activeClients = repository.activeClients
        activeClientCount = repository.activeClientCount
    }
    
    fun insert(client: Client) = viewModelScope.launch(Dispatchers.IO) {
        repository.insert(client)
    }
    
    fun update(client: Client) = viewModelScope.launch(Dispatchers.IO) {
        repository.update(client)
    }
    
    fun delete(client: Client) = viewModelScope.launch(Dispatchers.IO) {
        repository.delete(client)
    }
    
    fun searchClients(query: String): LiveData<List<Client>> {
        return repository.searchClients(query)
    }
    
    suspend fun getClientById(id: Int): Client? {
        return repository.getClientById(id)
    }
}
